% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_main.R
\name{simulation_main}
\alias{simulation_main}
\title{Doubly Adaptive Biased Coin Design with Simulated Data (Binary Responses)}
\usage{
simulation_main(n, nstart, p, nstop, replication, group_allo, rho_func_index,
rho_func, alpha, sig_level)
}
\arguments{
\item{n}{The number of patients. The default is 500.}

\item{nstart}{Burn-in sample size of each arm. The default is n/20.}

\item{p}{A vector containing response probabilities
for each treatment arm (where the first element refers to the control arm).
The length of p should correspond to the number of arms.
The default is p = c(0.3, 0.3, 0.6).}

\item{nstop}{A vector of stopping cap of sample size for each arm. The trial
stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 Any value greater than n will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{rho_func_index}{Supply a number of 1, 2 or 3 indicting the
allocation function to use; default to 3.
* 1 = Wei's allocation (Urn allocation);
* 2 = Neyman allocation;
* 3 (default) = Rosenberger allocation;}

\item{rho_func}{Supply a user-specified allocation function of S_RK when
rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}

\item{sig_level}{Significant level (one-sided). The default is 0.05.}
}
\value{
\itemize{
  \item allocation_mean - Average of allocation in each arm based on `replication` repeats
  \item allocation_sd - Standard deviation of allocation in each arm based on `replication` repeats
  \item SS_mean - Average of sample size in each arm based on `replication` repeats
  \item SS_sd - Standard deviation of sample size in each arm based on `replication` repeats
  \item power_chisq - Average power of chi-square test.
  \item power_oneside - Average power for each of the k-th arm to perform one-sided test against H0: p_1>p_k without multiplicity adjustment
  \item p_estimate_mean - Average of estimated success rate p
  \item p_estimate_sd - Standard deviation of estimated success rate p
}
}
\description{
Allocates patients to one of treatments based on the doubly adaptive biased
coin design with simulated data.
}
\details{
'simulation_main' can sample response and adaptively randomize
subjects group by group.
}
\examples{

## Default method
simulation_main(n = 500,
nstart = round(500 / 20),
p = c(0.3, 0.3, 0.6),
nstop=c(500,500,500),
replication = 5,
group_allo = 1,
rho_func_index = 3,
alpha = 2,
sig_level = 0.05
)

}
