% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ransac_nls.R
\name{ransac_nls}
\alias{ransac_nls}
\title{Robust Nonlinear Model Fitting via RANSAC}
\usage{
ransac_nls(
  formula,
  data,
  start,
  n_min,
  n_iter = 100,
  tol = 0.2,
  verbose = FALSE
)
}
\arguments{
\item{formula}{Model formula.}

\item{data}{Data frame containing the model variables.}

\item{start}{Named list of initial parameter estimates (as required by `nls`).}

\item{n_min}{Minimum number of points to fit the model.}

\item{n_iter}{Number of iterations (higher values make the model more robust).}

\item{tol}{Absolute tolerance to consider a point as an inlier.}

\item{verbose}{If `TRUE`, shows progress messages.}
}
\value{
An `nls` model fitted only to the inliers, with an additional class `"ransac_nls"` and an `"inliers"` attribute.
}
\description{
Fits a robust nonlinear model (`nls`) using the RANSAC algorithm.
}
\examples{
set.seed(123)
D <- seq(10, 50, by = 5)
H <- seq(15, 30, length.out = length(D))
V <- 0.01 * D^2 * H + rnorm(length(D), sd = 5)
V[c(3, 7)] <- V[c(3, 7)] + 50  # add outliers
data <- data.frame(D = D, H = H, V = V)

model <- ransac_nls(V ~ a * D^b * H^c, data = data,
                    start = list(a = 0.01, b = 2, c = 1),
                    n_min = 4, n_iter = 100, tol = 10)
summary(model)

}
