% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.cut.vars.r
\name{lsa.cut.vars}
\alias{lsa.cut.vars}
\title{Cut continuous variables into discrete categorical}
\usage{
lsa.cut.vars(
  data.file,
  data.object,
  src.variables,
  new.variables,
  new.var.labels,
  cut.points,
  value.labels,
  out.file
)
}
\arguments{
\item{data.file}{The file containing \code{lsa.data} object. Either this or
\code{data.object}
shall be specified, but not both. See details.}

\item{data.object}{The object in the memory containing \code{lsa.data} object. Either this
or \code{data.file} shall be specified, but not both. See details.}

\item{src.variables}{Names of the variables to cut into categories. Accepts only continuous
variables. No PV variables are accepted. See details.}

\item{new.variables}{The names of the new, cut variables to append to the dataset.
See details.}

\item{new.var.labels}{Optional, vector of strings to add as variable labels for the
\code{new.variables}. See details.}

\item{cut.points}{Vector of numeric values to cut the \code{src.variables} between.
See details.}

\item{value.labels}{Optional, character vector of values to assign to the newly formed
categorical discrete values in the \code{new.variables}. See details.}

\item{out.file}{Full path to the \code{.RData} file to be written. If missing, the
original object will be overwritten in the memory. See examples.}
}
\value{
A \code{lsa.data} object in memory (if \code{out.file} is missing) or \code{.RData} file containing \code{lsa.data} object with the new discrete variables.
}
\description{
\code{lsa.cut.vars} cuts continuous variables into discrete ones using user-defined ranges. For example, some continuous scales in large-scale assessments and surveys can be converted into two, three or more categories depending on the cut-points provided by the user.
}
\details{
The function cuts continuous variables in large-scale assessments' data in to variables with discrete values. The resulting variables can be numeric or categorical (i.e. factors) depending on if value labels for the new values are provided.

Either \code{data.file} or \code{data.object} shall be provided as source of data. If both of them are provided, the function will stop with an error message.

The \code{src.variables} specifies the variables that shall be cut. Only continuous variables are accepted. Multiple \code{src.variables} can be passed. These will be split at the same cut points (see below). PVs are not accepted.

The \code{new.variables} argument is optional and specifies the names of the new discrete variables from the \code{src.variables}. The sequence of the \code{new.variables} names is the same as the \code{src.variables}. If the \code{new.variables} argument is omitted, the function will create the names automatically, appending \code{CUT} at the end of the \code{src.variables} and store the discrete variable data under these names. If provided, the number of \code{new.variables} must be the same as the number of \code{src.variables}.

The \code{new.var.labels} is optional. Regardless whether \code{new.variables} are provided, if \code{new.var.labels} are provided, they will be assigned to the \code{new.variables} generated from the discretization. If neither \code{new.variables} not \code{new.var.labels} are provided, the function will automatically generate \code{new.variables} (see above) and copy the variable labels from \code{src.variables} to the newly generated variables, appending \code{Cut} at the beginning. The argument takes a vector with the same number of elements as the number of variable names in \code{src.variables}.

\code{cut.points} is a mandatory argument. It specifies the ranges (from-to) in the original variables to be cut into discrete categories. There can be multiple \code{cut.points}, the new values will be the ranges between them. For example, if the \code{3.29309}, \code{7.97028}, \code{9.98618}, and \code{10.99411} cut points are passed, there will be five categories in the resulting discrete variables, as follow:
\enumerate{
\item 1 - from lowest up to 3.29309;
\item 2 - from above 3.29309 up to 7.97028;
\item 3 - from above 7.97028 up to 9.98618;
\item 4 - from above 9.98618 up to 10.99411; and
\item 5 - from above 10.99411 to the highest value.
}

The \code{cut.points} must be within the range of the \code{src.variables}. Otherwise the function will stop with an error.

The \code{value.labels} is optional. If omitted, the values in the new discrete variables will be numeric (integers). If the data was exported with \code{missing.to.NA = FALSE} (i.e. user-defined missings are kept) the missing values will remain as they are. If the \code{value.labels} are provided, the new values will be converted to factor levels. If the data was exported with \code{missing.to.NA = FALSE} the names of missing values will be assigned to factor levels too. Either way, the missing values will remain as missing values and handled properly by the analysis functions. If \code{missing.to.NA = TRUE} (i.e. setting the user-defined missing values to \code{NA}), the \code{NA} values will remain as \code{NA} in the resulting discrete \code{new.variables}.

If full path to \code{.RData} file is provided to \code{out.file}, the data.set will be written to that file. If no, the complemented data will remain in the memory.
}
\examples{

# Produce new discrete variables from the PIRLS 2021 Students Like Reading and the
# Home Resources for Learning scales. The values for the new variables are
# numeric. Save the dataset into a file, overwriting it. The names for the new
# variables are automatically generated.
\dontrun{
lsa.cut.vars(data.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData",
src.variables = c("ASBGSLR", "ASBGHRL"),
cut.points = c(4.1, 7.9, 9.9, 10.7),
out.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData")
}

# Same as the above, but assign custom variable names, value labels for the new categorical
# variables, custom variable labels. Write the data to the memory instead of saving it on
# the disk.
\dontrun{
lsa.cut.vars(data.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData",
src.variables = c("ASBGSLR", "ASBGHRL"),
new.variables = c("ASBGSLRREC", "ASBGHRLREC"),
new.var.labels = c("Categorical like reading", "Categorical learning resources"),
cut.points = c(4.1, 7.9, 9.9, 10.7),
value.labels = c("Very low", "Low", "Medium", "High", "Very high"),
out.file = "C:/Data/PIRLS_2021_Student_Miss_to_NA.RData")
}

}
\seealso{
\code{\link{lsa.convert.data}}, \code{\link{lsa.recode.vars}}
}
