% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.epid.R
\name{fit.epid.optim}
\alias{fit.epid.optim}
\title{Joint estimation of R and generation time distribution for the ML method}
\usage{
fit.epid.optim(par = c(1, 1, 1), ...)
}
\arguments{
\item{par}{A vector of three numerical values to be optimized, in the order \code{c(log.R, GT$mean, GT$sd)}.}

\item{...}{Parameters passed to inner functions.}
}
\value{
A Poisson log-likelihood from \code{\link[=fit.epid]{fit.epid()}}.
}
\description{
An objective function, wrapped around \code{\link[=fit.epid]{fit.epid()}}, that will be passed to
\code{\link[stats:optim]{stats::optim()}} to jointly estimate the best-fitting R and GT distributions
in the context of the Maximum-Likelihood method from \code{\link[=est.R0.ML]{est.R0.ML()}}.
}
\details{
For internal use. Called from \code{\link[=est.R0.ML]{est.R0.ML()}}.

This is a wrapper function used to pass proper arguments to \code{\link[=fit.epid]{fit.epid()}} when
the ML method is used to estimate simultaneously R and GT. This function is
used as objective to maximize by \code{\link[stats:optim]{stats::optim()}}.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
