% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluorescence_summaries.R
\name{summary.flFit}
\alias{summary.flFit}
\title{Generic summary function for flFit objects}
\usage{
\method{summary}{flFit}(object, ...)
}
\arguments{
\item{object}{object of class \code{flFit}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from all fits of a workflow.
}
\description{
Generic summary function for flFit objects
}
\examples{
# load example dataset
input <- read_data(data.growth = system.file("lac_promoters_growth.txt", package = "QurvE"),
                   data.fl = system.file("lac_promoters_fluorescence.txt", package = "QurvE"),
                   csvsep = "\t",
                   csvsep.fl = "\t")

# Run curve fitting workflow
res <- flFit(fl_data = input$norm.fluorescence,
             time = input$time,
             parallelize = FALSE,
             control = fl.control(fit.opt = 's', suppress.messages = TRUE,
             x_type = 'time', norm_fl = TRUE, nboot.fl = 20))

summary(res)

}
