% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PartitionDistance.R
\name{PairSharedSplitStatus}
\alias{PairSharedSplitStatus}
\title{Pair shared split status}
\usage{
PairSharedSplitStatus(ref, cf)
}
\arguments{
\item{ref, cf}{Trees of class \code{\link[ape:read.tree]{phylo}} to compare.}
}
\value{
Named integer of length 6, as per \code{\link[=CompareSplits]{CompareSplits()}}
}
\description{
Removes all tips that do not occur in both \code{ref} and \code{cf}, then calculates
the status of the remaining splits.
}
\examples{

library("TreeTools")
ref <- BalancedTree(letters[1:9])
cf <- BalancedTree(letters[3:13])

PairSharedSplitStatus(ref, cf)

}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\keyword{internal}
