% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpreadCalculation.R
\name{SpreadCalculation}
\alias{SpreadCalculation}
\title{Spread Calculation Data}
\usage{
SpreadCalculation(
  calculation,
  id_col = "content",
  rep_col = "replicate",
  terms = c("RAF", "MPR", "MS")
)
}
\arguments{
\item{calculation}{A data frame containing the metadata and results of the calculation. Output from \code{GetCalculation()}.}

\item{id_col}{The name of the column in calculation that identifies the content. Default is 'content'.}

\item{rep_col}{The name of the column in calculation that identifies the replicate. Default is 'replicate'.}

\item{terms}{A vector of column names to spread.  Defaults to 'RAF', 'MPR', and 'MS'.}
}
\value{
A list of data frames containing the spread results of the calculation. Each data frame is compatible with
various graphing software, particularly GraphPad Prism, which is the most commonly used graphing tool in F-SAA research.
}
\description{
This function takes a data frame containing metadata and calculation results,
and spreads the results into a list of data frames for selected calculation term.
}
\examples{
calculation <- data.frame(
  content = rep(c("A", "B", "C"), each = 2),
  replicate = rep(1:2, 3),
  time_to_threshold = rnorm(6),
  RAF = rnorm(6),
  MPR = rnorm(6),
  MS = rnorm(6)
  )

calculation_spread = SpreadCalculation(calculation)
print(calculation_spread)

}
