% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanMeta.R
\name{CleanMeta}
\alias{CleanMeta}
\title{Get Clean Metadata}
\usage{
CleanMeta(
  raw,
  plate,
  replicate,
  split_content = FALSE,
  split_by = "_",
  split_into = c(),
  del_na = TRUE
)
}
\arguments{
\item{raw}{A dataframe containing the raw data.}

\item{plate}{A dataframe containing the plate layout information.}

\item{replicate}{A dataframe containing the replicate information. Output of \code{GetReplicate()}.}

\item{split_content}{Logical, whether to split the content. Default is FALSE.}

\item{split_by}{A character string to split the content by. Default is "_".}

\item{split_into}{A character vector specifying names for the split columns. Required if split_content is TRUE.}

\item{del_na}{Logical, whether to drop rows containing NA. Default is TRUE.}
}
\value{
A data frame containing the cleaned metadata.
}
\description{
This function processes raw data (raw), plate layout (plate), and replicate information (replicate) to create a clean metadata dataframe.
It can optionally split the content column into additional columns.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)
head(meta)

}
