% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thyc_qol.R
\name{thyc_qol}
\alias{thyc_qol}
\title{Calculates the domain-based scale scores of Thyroid cancer using the data of QLQ-THY34}
\usage{
thyc_qol(x)
}
\arguments{
\item{x}{A data frame with ID, THY_Q31,THY_Q32,...,THY_Q64 columns along with other columns if data is available.}
}
\value{
A data frame by replacing the columns 'THY_Q31','THY_Q32',...,'THY_Q64' by the domain-based scale scores.
}
\description{
Creates a dataset containing the domain-based scale scores using
the data from QLQ-THY34
}
\details{
brc_miss function inputs either a dataset containing missing information, represented as,
9 or 99 or NA or a data not containing any missing information. It extracts only the columns
named 'THY_Q31','THY_Q32',...,'THY_Q64' and replaces the missing data with the minimum value of the particular question.

Using each of the 30 columns, the Raw Score is computed, and one column is obtained containing
the Raw Score for each patient.

Further, using each of the Raw Scores, three domain-based Scale Scores are computed,
they are, Functional Scales Score and Symptoms Scales Score.

Thus, the columns 'THY_Q31','THY_Q32',...,'THY_Q64' are replaced by the domain-based scale scores,
which is obtained as the output.

thyc_qol(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'THY_Q31' for data from question 31,
'THY_Q32' for data from question 32, and so on until 'THY_Q64' for data from question 64

3) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, THY_Q31,THY_Q32,...,THY_Q64 columns along with other columns if data
is available.

rs - A matrix containing the Raw Score computed using all THY_Q31 to THY_Q64 data for each
patient. The RS(a) function is used in this case.

ss - A matrix containing the Global Scale Scores computed using all THY_Q31 to THY_Q64
data for each patient. The SS(a,b) function is used in this case.

final_data - A data frame formed by replacing the columns 'THY_Q31','THY_Q32',...,'THY_Q64' by
the domain-based scale scores.
}
\examples{
##
data(thyc_df)
thyc_qol(thyc_df)
data(thyc_df_miss)
thyc_qol(thyc_df_miss)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
