% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_c30_miss.R
\name{surv_c30_miss}
\alias{surv_c30_miss}
\title{Dataset contains survival outcomes and quality of life for cancer patients with missing observation}
\usage{
surv_c30_miss(x)
}
\arguments{
\item{x}{A data frame with ID, time, event, arm, Q1,Q2,...,Q30 columns along with other columns if data is available.}
}
\value{
A data frame containing the Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.
}
\description{
Creates a dataset containing the domain-based relative hazard ratio (95% CI) using
the arm-wise data from QLQ-C30
}
\details{
Calculates the domain-wise relative hazard ratio (95% CI) using the arm-wise data from QLQ-C30

surv_c30_miss function inputs a dataset where information of some patients
are completely missing, that is, some rows contain only NA. It passes the data to the qol_miss()
function, which in turn gives the domain-wise scale scores. These domain-wise scale scores are used
for calculating the relative hazard ratio (95% CI) by first computing the hazard ratios by dividing
the data arm-wise.

The surv_c30_miss function includes the qol_miss() function which will consider the arm-wise data and
calculate the domain-wise scale scores. Hence, two set of domain-wise scale scores will be obtained,
one for each arm.

Each of the domain-wise scales, 'QL','PF','RF','EF','CF','SF','FA','NV','PA','DY','SL','AP','CO','DI','FI', are considered
as the covariates. Using these columns, Cox-Proportional model will be used for univariate analysis for
each of the covariates. The hazard ratio (95% CI) obtained for each arm is used to find out the relative hazard ratio (95% CI).

Thus, the output will contain three columns, Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.

surv_c30_miss(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'Q1' for data from question 1,'Q2' for data from question 2, and so on until 'Q30' for data from question 30.

3) Only those data can be used which contains no information for some patients, that is, some rows contain only NA.

4) Data must contain columns for 'time', 'event' and 'arm'.

5) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, time, event, arm, Q1,Q2,...,Q30 columns along with other columns if data is available.
}
\examples{
##
data(patient_miss)
surv_c30_miss(patient_miss)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
