% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gene_Mean_CenIPWE.R
\name{Gene_Mean_CenIPWE}
\alias{Gene_Mean_CenIPWE}
\title{A low-level function for the generic optimization step in estimating Mean-optimal
treatment regime for censored data}
\usage{
Gene_Mean_CenIPWE(data_aug, ph, p_level, regimeClass, Domains = NULL,
  cluster = FALSE, s.tol = 1e-04, it.num = 8, pop.size = 3000)
}
\arguments{
\item{data_aug}{a data.frame of the observed data after preprocessing. It should include be
augmented with two new columns: \code{ph} for the enstimated propensity scores and 
\code{ghat} for the estimated conditional survival probabilities.}

\item{ph}{propensity score estimates. For example, if the treatment is denoted by \code{A},
then \code{ph} should be P(A=1|X)}

\item{p_level}{printing level}

\item{regimeClass}{a formula indicating the form of treatment regimes}

\item{Domains}{default is NULL. Otherwise, the object should be a \code{nvars *2} 
matrix used as the space of parameters, which will be supplied to \code{rgenoud::genoud}.}

\item{cluster}{default is FALSE. This can also be an object of the 'cluster' class 
returned by one of the makeCluster commands in the parallel package or
 a vector of machine names so rgenoud::genoud can setup the cluster automatically.}

\item{s.tol}{tolerance level for the GA algorithm. This is input for parameter \code{solution.tolerance}
in function \code{rgenoud::genoud}.}

\item{it.num}{the maximum GA iteration number}

\item{pop.size}{an integer with the default set to be 3000. This is roughly the 
number individuals for the first generation
in the genetic algorithm (\code{rgenoud::genoud}).}
}
\description{
This function supports the \code{IPWE_mean_IndCen} function.
It does the genetic algorithm based method with inverse probability weighting for censored data. 
In the future, if more complicated applications/scenarios is sought after for mean optimality, 
users may create their own wrapper function
based on \code{Gene_Mean_CenIPWE}.
}
\examples{
GenerateData <- function(n)
{
  x1 <- runif(n, min=-0.5,max=0.5)
  x2 <- runif(n, min=-0.5,max=0.5)
  error <- rnorm(n, sd= 1)
  ph <- rep(0.5,n)
  a <- rbinom(n = n, size = 1, prob=ph)
  c <- 1.5 +  + runif(n = n, min=0, max=2)
  cmplt_y <-  pmin(2+x1+x2 +  a*(1 - x1 - x2) +  (0.2 + a*(1+x1+x2)) * error, 4.4)
  censor_y <- pmin(cmplt_y, c)
  delta <- as.numeric(c > cmplt_y)
  return(data.frame(x1=x1,x2=x2,a=a, censor_y = censor_y, delta=delta))
}
n <- 100
data <- GenerateData(n)

# preprocessing
data_aug <- data
data_aug$ph <- rep(mean(data$a), n)
data_aug$deltaC <- 1 - data_aug$delta
library(survival)
survfit_all <- survfit(Surv(censor_y, event = deltaC)~1, data=data_aug)
survest <- stepfun(survfit_all$time, c(1, survfit_all$surv))
data_aug$ghat <- survest(data_aug$censor_y)

# estimate the mean-optimal treatment regime
meanopt_fit <- Gene_Mean_CenIPWE(data=data_aug, ph = data_aug$ph, p_level=1, regimeClass=a~x1*x2) 

}
