% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZhouF.R
\name{ZhouMethod_single_env}
\alias{ZhouMethod_single_env}
\title{The second step of Zhou method for single environment}
\usage{
ZhouMethod_single_env(
  Model = NULL,
  pheRaw = NULL,
  genRaw = NULL,
  mapRaw = NULL,
  CriLOD = NULL,
  NUM = NULL,
  yygg = NULL,
  genoname = NULL,
  Ax0 = NULL,
  Hx0 = NULL,
  Bx0 = NULL,
  Ax = NULL,
  Hx = NULL,
  Bx = NULL,
  dir = NULL,
  CriDis = NULL,
  CLO = NULL
)
}
\arguments{
\item{Model}{Random or fixed model.}

\item{pheRaw}{phenotype matrix.}

\item{genRaw}{genotype matrix.}

\item{mapRaw}{linkage map matrix.}

\item{CriLOD}{Critical LOD scores for significant QTL.}

\item{NUM}{The serial number of the trait to be analyzed.}

\item{yygg}{covariate matrix.}

\item{genoname}{linkage map matrix with pseudo markers inserted.}

\item{Ax0}{AA genotype matrix.}

\item{Hx0}{Aa genotype matrix.}

\item{Bx0}{aa genotype matrix.}

\item{Ax}{AA genotype matrix with pseudo markers inserted.}

\item{Hx}{Aa genotype matrix with pseudo markers inserted.}

\item{Bx}{aa genotype matrix with pseudo markers inserted.}

\item{dir}{file storage path.}

\item{CriDis}{The distance of optimization.}

\item{CLO}{Number of CPUs.}
}
\value{
a list
}
\description{
The second step of Zhou method for single environment
}
\examples{
data(F2data)
readraw<-Readdata(file=F2data,fileFormat="GCIM",
method="GCIM-QEI",filecov=NULL,
MCIMmap=NULL,MultiEnv=FALSE)
DoResult<-Dodata(fileFormat="GCIM",Population="F2",
method="GCIM-QEI",Model="Random",
readraw,MultiEnv=FALSE)
ZhouMatrices<-ZhouF(pheRaw=DoResult$pheRaw,
genRaw=DoResult$genRaw,mapRaw1=DoResult$mapRaw1,
WalkSpeed=1,CriLOD=3,dir=tempdir())
OutputZhou<-ZhouMethod_single_env(Model="Random",
pheRaw=DoResult$pheRaw,genRaw=DoResult$genRaw,
mapRaw=ZhouMatrices$mapRaw,CriLOD=3,NUM=1,
yygg=DoResult$yygg1,genoname=ZhouMatrices$genoname,
Ax0=ZhouMatrices$Ax0,Hx0=ZhouMatrices$Hx0,
Bx0=ZhouMatrices$Bx0,Ax=ZhouMatrices$Ax,
Hx=ZhouMatrices$Hx,Bx=ZhouMatrices$Bx,
dir=tempdir(),CriDis=5,CLO=2)
}
