% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WenF.r
\name{WenF}
\alias{WenF}
\title{To perform QTL mapping with Wen method}
\usage{
WenF(
  pheRaw = NULL,
  genRaw = NULL,
  mapRaw1 = NULL,
  yygg1 = NULL,
  cov_en = NULL,
  WalkSpeed = NULL,
  CriLOD = NULL,
  dir = NULL
)
}
\arguments{
\item{pheRaw}{phenotype matrix.}

\item{genRaw}{genotype matrix.}

\item{mapRaw1}{linkage map matrix.}

\item{yygg1}{the transformed covariate matrix.}

\item{cov_en}{raw covariate matrix.}

\item{WalkSpeed}{Walk speed for Genome-wide Scanning.}

\item{CriLOD}{Critical LOD scores for significant QTL.}

\item{dir}{file path in your computer.}
}
\value{
a list
}
\description{
To perform QTL mapping with Wen method
}
\examples{
data(F2data)
readraw<-Readdata(file=F2data,fileFormat="GCIM",
method="GCIM",filecov=NULL,MCIMmap=NULL,
MultiEnv=FALSE)
DoResult<-Dodata(fileFormat="GCIM",Population="F2",
method="GCIM",Model="Random",readraw,MultiEnv=FALSE)
wf<-WenF(pheRaw=DoResult$pheRaw,
genRaw=DoResult$genRaw,mapRaw1=DoResult$mapRaw1,
yygg1=DoResult$yygg1,cov_en=DoResult$cov_en,
WalkSpeed=1,CriLOD=2.5,dir=tempdir())
}
