% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i.R
\name{QR}
\alias{QR}
\title{QR factorization without pivoting}
\source{
LAPACK routine DGEQRF is used for the QR factorization without pivoting.
}
\usage{
QR(A, complete = FALSE)
}
\arguments{
\item{A}{a numeric matrix whose QR decomposition is to be computed.}

\item{complete}{boolean that indicates if the R matrix should be completed with 0s
to its full rank.}
}
\value{
Returns a list with the following components:
 \item{qr}{a matrix with the same dimensions as A. The upper triangle contains
 the \bold{R} of the decomposition and the lower triangle contains information
 on the \bold{Q} of the decomposition (stored in compact form).}
 \item{qraux}{a vector of length ncol(A) which contains additional
 information on \bold{Q}.}
 \item{Q}{an orthogonal matrix such that Q*R is the input matrix.}
 \item{R}{an upper triangular matrix such that Q*R is the input matrix.}
}
\description{
This function performs QR factorization without pivoting to a numeric matrix A.
}
\details{
This method is an alternative to the default qr function of base R.
The default function returns a pivoted solution in many cases, which is
not always the desired solution. In this function, we returned the unpivoted
solution for the QR factorization using the LAPACK routine DGEQRF. Currently,
the function only works for real numbers.
}
\examples{

set.seed(2)
A<-matrix(sample(-20:20, size = 25, replace = TRUE),5,5)
qres<-QR(A)

#Inspect the main results of the factorization:
qres$Q
qres$R

}
\references{
Anderson. E. and ten others (1999) LAPACK Users' Guide. Third Edition. SIAM.
Available on-line at http://www.netlib.org/lapack/lug/lapack_lug.html.
}
\keyword{QR}
\keyword{factorization}
