% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ry.R
\name{Ry}
\alias{Ry}
\title{Rotation operation about y-axis of the Bloch sphere}
\usage{
Ry(n, theta)
}
\arguments{
\item{n}{a vector/matrix}

\item{theta}{an angle}
}
\value{
A vector or a matrix after operating the Rotation gate about the y-axis of the Bloch sphere, by an angle \code{theta}, on a conformable input matrix or a vector \code{n}.
}
\description{
This function operates the Rotation gate about the y-axis of the Bloch sphere by an angle \code{theta} on a conformable input matrix \code{n}.
}
\examples{
init()
Ry(Q$Q1, pi/3)

}
\references{
\url{https://en.wikipedia.org/wiki/Quantum_logic_gate}\cr
\url{http://www2.optics.rochester.edu/~stroud/presentations/muthukrishnan991/LogicGates.pdf}\cr
\url{http://www.physics.udel.edu/~msafrono/650/Lecture\%204\%20-\%205.pdf}\cr
}
