% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QDuels_Alice_payoffs.R
\name{QDuels_Alice_payoffs}
\alias{QDuels_Alice_payoffs}
\title{Quantum Two Person Duel game}
\usage{
QDuels_Alice_payoffs(Psi, n, a, b, alpha1, alpha2, beta1, beta2)
}
\arguments{
\item{Psi}{a vector representing the initial quantum state}

\item{n}{an integer}

\item{a}{a number}

\item{b}{a number}

\item{alpha1}{a number}

\item{alpha2}{a number}

\item{beta1}{a number}

\item{beta2}{a number}
}
\value{
A list consisting of the payoff value to Alice depending on three situations of the quantum duel game: 1) The game is continued for \code{n} rounds and none of the players shoots at the air, 2) The game is continued for 2 rounds and Alice shoots at the air in her second round and 3) The game is continued for 2 rounds and Bob shoots at the air in her second round.
}
\description{
This function returns the expected payoff to Alice for three possible cases for the Quantum Duel game:
\enumerate{
\item The game is continued for \code{n} rounds and none of the players shoots at the air.
\item The game is continued for 2 rounds and Alice shoots at the air in her second round.
\item The game is continued for 2 rounds and Bob shoots at the air in her second round.
}

\code{Psi} is the initial state of the quantum game, \code{n} is the number of rounds, \code{a} is the probability of Alice missing the target, \code{b} is the probability of Bob missing the target, and \code{alpha1, alpha2, beta1, beta2} are arbitrary phase factors that lie in -pi to pi that control the outcome of a poorly performing player.
}
\examples{
init()
QDuels_Alice_payoffs(Q$Q11, 5, 0.666666, 0.5, 0, 0, 0.2, 0.7)
Qs <- (Q$Q0+Q$Q1)/sqrt(2)
Psi <- kronecker(Qs, Qs)
QDuels_Alice_payoffs(Psi, 5, 0.666666, 0.5, 0, 0, 0.2, 0.7)

}
\references{
\url{https://arxiv.org/pdf/quant-ph/0506219.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0208069.pdf}\cr
\url{https://arxiv.org/pdf/quant-ph/0305058.pdf}\cr
}
