% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDSDS.R
\name{IDSDS}
\alias{IDSDS}
\title{Iterated Deletion of Strictly Dominated Strategies algorithm}
\usage{
IDSDS(P1, P2)
}
\arguments{
\item{P1}{Payoff matrix to Alice}

\item{P2}{Payoff matrix to Bob}
}
\value{
A list consisting of the equilibrium strategies based on the rationality of the players by application of the IDSDS algorithm on \code{P1} and \code{P2}.
}
\description{
This function applies the IDSDS algorithm to result in the equilibrium strategies based on the rationaility of the players. The input parameters are equal dimensional payoff matrices for the first and the second players.
}
\examples{
init()
Alice <- matrix(c(8, 0, 3, 3, 2, 4, 2, 1, 3), ncol=3, byrow=TRUE)
Bob <- matrix(c(6, 9, 8, 2, 1, 3, 8, 5, 1), ncol=3, byrow=TRUE)
IDSDS(Alice, Bob)

}
\references{
\url{https://arxiv.org/abs/1512.06808}\cr
\url{https://en.wikipedia.org/wiki/Strategic_dominance}\cr
}
