% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ForwardStart.R
\name{ForwardStartBS}
\alias{ForwardStartBS}
\title{ForwardStart option valuation via Black-Scholes (BS) model}
\usage{
ForwardStartBS(o = OptPx(Opt(Style = "ForwardStart")), tts = 0.1)
}
\arguments{
\item{o}{an \code{OptPx} object including basic information of an option}

\item{tts}{Time to start of the option (in years)}
}
\value{
The original user-supplied \code{OptPX} object
with price field \code{PxBS} and any other provided user-supplied parameters.
}
\description{
Compute the price of Forward Start options using BSM.
A forward start option is a standard European option whose strike price is set equal to current asset price at some prespecified future date.
Employee incentive options are basically forward start option
}
\details{
A standard European option starts at a future time tts.
}
\examples{
(o = ForwardStartBS())$PxBS

o = OptPx(Opt(Style='ForwardStart', Right='Put'))
(o = ForwardStartBS(o))$PxBS
}
\author{
Tongyue Luo, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8.\url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
p.602
}

