% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Chooser.R
\name{ChooserBS}
\alias{ChooserBS}
\title{Chooser option valuation via Black-Scholes (BS) model}
\usage{
ChooserBS(o = OptPx(Opt(Style = "Chooser")), t1 = 9/12, t2 = 3/12)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{t1}{The time to maturity of the call option, measured in years.}

\item{t2}{The time to maturity of the put option, measured in years.}
}
\value{
A list of class \code{SimpleChooserBS} consisting of the original \code{OptPx} object
             and the option pricing parameters \code{t1}, \code{t2},
             as well as the computed price \code{PxBS}.
}
\description{
Compute an exotic option that allow the holder decide the option
             will be a call or put option at some predetermined future date.
             In a simple case, both put and call option are plain vanilla option.
     The value of the simple chooser option is \eqn{\max{C(S,K,t_1),P(S,K,t_2)}}.
             The plain vanilla option is calculated based on the BS model.
}
\examples{
(o = ChooserBS())$PxBS

o = Opt(Style='Chooser',Right='Other',S0=50, K=50)
(o = ChooserBS(OptPx(o, r=0.06, q=0.02, vol=0.2),9/12, 3/12))$PxBS

o = Opt(Style='Chooser',Right='Other',S0=50, K=50)
(o = ChooserBS (OptPx(o,r=0.08, q=0, vol=0.25),1/2, 1/4))$PxBS

o = Opt(Style='Chooser',Right='Other',S0=100, K=50)
(o = ChooserBS(OptPx(o,r=0.08, q=0.05, vol=0.3),1/2, 1/4))$PxBS
}
\author{
Le You, Department of Statistics, Rice University, spring 2015
}
\references{
\itemize{
\item{Hull, John C.,\emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
     ISBN 978-0-13-345631-8. \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}}
\item{Huang Espen G., \emph{Option Pricing Formulas}, 2ed.
    \url{http://down.cenet.org.cn/upfile/10/20083212958160.pdf} }
\item{Wee, Lim Tiong, MFE5010 \emph{Exotic Options,Notes for Lecture 4 Chooser option}.
    \url{http://www.stat.nus.edu.sg/~stalimtw/MFE5010/PDF/L4chooser.pdf} }
\item{Humphreys, Natalia A., ACTS 4302 Principles of Actuarial Models: Financial Economics.
    \emph{Lesson 14: All-or-nothing, Gap, Exchange and Chooser Options}.
     } }
}

