% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Barrier.R
\name{BarrierMC}
\alias{BarrierMC}
\title{Barrier option valuation via Monte Carlo (MC) simulation.}
\usage{
BarrierMC(o = OptPx(o = Opt(Style = "Barrier")), knock = c("In", "Out"),
  B = 60, NPaths = 5)
}
\arguments{
\item{o}{The \code{OptPx} Barrier option to price.}

\item{knock}{Defines the Barrier option to be "\code{In}" or "\code{Out}"}

\item{B}{The Barrier price level}

\item{NPaths}{The number of simulation paths to use in calculating the price}
}
\value{
The option \code{o} with the price in the field \code{PxMC} based on MC simulations and the Barrier option
        properties set by the users themselves
}
\description{
Calculates the price of a Barrier Option using 10000 Monte Carlo simulations.
The helper function BarrierCal() aims to calculate expected payout for each stock prices.

Important Assumptions:
The option follows a General Brownian Motion (GBM)
\eqn{ds = mu * S * dt + sqrt(vol) * S * dW} where \eqn{dW ~ N(0,1)}.
The value of \eqn{mu} (the expected percent price increase) is assumed to be \code{o$r-o$q}.
}
\examples{
(o = BarrierMC())$PxMC #Price =~ $11

 o = OptPx(o=Opt(Style='Barrier'),NSteps = 10)
 (o = BarrierMC(o))$PxMC #Price =~ $14.1

 (o = BarrierMC(NPaths = 5))$PxMC # Price =~ $11

 (o = BarrierMC(B=65))$PxMC # Price =~ $10

 (o = BarrierMC(knock="Out"))$PxMC #Price =~ $1
}
\author{
Huang Jiayao, Risk Management and Business Intelligence at Hong Kong University of Science and Technology,
         Exchange student at Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
Also,
\url{http://stackoverflow.com/questions/25946852/r-monte-carlo-simulation-price-path-converging-volatility-issue}
}

