% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{login_gigwa}
\alias{login_gigwa}
\title{Login to the GIGWA Server}
\usage{
login_gigwa(username = NULL, password = NULL)
}
\arguments{
\item{username}{The GIGWA username (optional, default is NULL).}

\item{password}{The GIGWA password (optional, default is NULL).}
}
\value{
No return value. The authentication token will be stored internally.
}
\description{
Connect to the GIGWA server. If the \code{username} or \code{password} parameters are missing,
a login window will be triggered to capture these details.

All connection settings (server URL, port, API path, and protocol) are read from the
\code{qbms_config()} list. The function will request an authentication token from the server
and update the \code{qbms_state()} list with the token.
}
\examples{
if (interactive()) {
  set_qbms_config("http://localhost:59395/gigwa/index.jsp", time_out = 300, engine = "gigwa")

  # Login using your GIGWA account (interactive mode)
  login_gigwa()
  
  # You can pass GIGWA username and password as parameters (batch mode)
  # login_gigwa("gigwadmin", "nimda")
}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
