% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{chooseK_mds}
\alias{chooseK_mds}
\title{Choose the number of multidimensional scaling features}
\usage{
chooseK_mds(seqs = NULL, K_cand, dist_type = "oss_action",
  n_fold = 5, max_epoch = 100, step_size = 0.01, tot = 1e-06,
  return_dist = FALSE, L_set = 1:3)
}
\arguments{
\item{seqs}{a \code{"\link{proc}"} object or a square matrix. If a squared matrix is 
provided, it is treated as the dissimilary matrix of a group of response processes.}

\item{K_cand}{the candidates of the number of features.}

\item{dist_type}{a character string specifies the dissimilarity measure for two
response processes. See 'Details'.}

\item{n_fold}{the number of folds for cross-validation.}

\item{max_epoch}{the maximum number of epochs for stochastic gradient
descent.}

\item{step_size}{the step size of stochastic gradient descent.}

\item{tot}{the accuracy tolerance for determining convergence.}

\item{return_dist}{logical. If \code{TRUE}, the dissimilarity matrix will be
returned. Default is \code{FALSE}.}

\item{L_set}{length of ngrams considered}
}
\value{
\code{chooseK_mds} returns a list containing
  \item{K}{the value in \code{K_cand} producing the smallest cross-validation loss.}
  \item{K_cand}{the candidates of the number of features.}
  \item{cv_loss}{the cross-validation loss for each candidate in \code{K_cand}.}
  \item{dist_mat}{the dissimilary matrix. This element exists only if \code{return_dist=TRUE}.}
}
\description{
\code{chooseK_mds} choose the number of multidimensional scaling features
  to be extracted by cross-validation.
}
\examples{
n <- 50
set.seed(12345)
seqs <- seq_gen(n)
K_res <- chooseK_mds(seqs, 5:10, return_dist=TRUE)
theta <- seq2feature_mds(K_res$dist_mat, K_res$K)$theta

}
\references{
Gomez-Alonso, C. and Valls, A. (2008). A similarity measure for sequences of
  categorical data based on the ordering of common elements. In V. Torra & Y. Narukawa (Eds.) 
  \emph{Modeling Decisions for Artificial Intelligence}, (pp. 134-145). Springer Berlin Heidelberg.
}
\seealso{
\code{\link{seq2feature_mds}} for feature extraction after choosing
  the number of features.
}
