test_that("scales functions works", {
  fill_scale <- scale_fill_pretty_c(palette = "Greens")
  expect_equal(fill_scale$is_discrete(), FALSE)
  expect_error(scale_fill_pretty_c(palette = "Green"))
  expect_error(scale_fill_pretty_c(palette = "Greens", direction = 0))

  fill_scale <- scale_fill_pretty_div(palette = "PinkGreens")
  expect_equal(fill_scale$is_discrete(), FALSE)
  expect_error(scale_fill_pretty_div(palette = "Teals"))
  expect_error(scale_fill_pretty_div(palette = "PinkGreens", direction = 0))

  fill_scale <- scale_fill_pretty_d(palette = "Relax")
  expect_equal(fill_scale$is_discrete(), TRUE)
  fill_scale <- scale_fill_pretty_d(palette = "Relax", direction = -1)
  expect_equal(fill_scale$is_discrete(), TRUE)
  expect_error(scale_fill_pretty_d(palette = "Relaxing"))
  expect_error(scale_fill_pretty_d(palette = "Relax", direction = 0))

  colour_scale <- scale_colour_pretty_c(palette = "Greens")
  expect_equal(colour_scale$is_discrete(), FALSE)
  expect_error(scale_colour_pretty_c(palette = "Green"))
  expect_error(scale_colour_pretty_c(palette = "Greens", direction = 0))

  colour_scale <- scale_color_pretty_c(palette = "Greens")
  expect_equal(colour_scale$is_discrete(), FALSE)
  expect_error(scale_color_pretty_c(palette = "Green"))
  expect_error(scale_color_pretty_c(palette = "Greens", direction = 0))

  colour_scale <- scale_colour_pretty_div(palette = "PinkGreens")
  expect_equal(colour_scale$is_discrete(), FALSE)
  expect_error(scale_colour_pretty_div(palette = "Teals"))
  expect_error(scale_colour_pretty_div(palette = "PinkGreens", direction = 0))

  color_scale <- scale_color_pretty_div(palette = "PinkGreens")
  expect_equal(color_scale$is_discrete(), FALSE)
  expect_error(scale_color_pretty_div(palette = "Teals"))
  expect_error(scale_color_pretty_div(palette = "PinkGreens", direction = 0))

  colour_scale <- scale_colour_pretty_d(palette = "Relax")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_colour_pretty_d(palette = "Relax", direction = -1)
  expect_equal(colour_scale$is_discrete(), TRUE)
  expect_error(scale_colour_pretty_d(palette = "Relaxing"))
  expect_error(scale_colour_pretty_d(palette = "Relax", direction = 0))

  colour_scale <- scale_color_pretty_d(palette = "Relax")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_color_pretty_d(palette = "Relax", direction = -1)
  expect_equal(colour_scale$is_discrete(), TRUE)
  expect_error(scale_color_pretty_d(palette = "Relaxing"))
  expect_error(scale_color_pretty_d(palette = "Relax", direction = 0))
})
