% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_funcs.R
\name{process_data}
\alias{process_data}
\title{Convert data to R format if saved to disk}
\usage{
process_data(matrix, type = "csv", folder, prefix = NULL)
}
\arguments{
\item{matrix}{path to the original matrix.}

\item{type}{csv or tab. Is the original matrix comma separated
or tab separated? Default: csv}

\item{folder}{path to the folder where output data was saved.}

\item{prefix}{optional prefix to file names}
}
\value{
object formatted in the same way the output of 
ComputeEntryWisePerturbationExpectation
}
\description{
This function will convert objects saved to disk to
R friendly objects, or the same output as 
ComputeEntryWisePerturbationExpectation.
If you used the "save to disk" option or ran via python
directly, run this function to read the data into R.
Files read in: asymptotic_stability.npy, column_names.txt,
distributions.pkl, expected_num_switch.csv,
num_non_zero.npy, num_switch_funcs.pkl, 
row_names.txt and size.npy.
Note how most of these objects are python based objects-
numpy or pickle objects.
}
\examples{
\dontrun{
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt")
data <- process_data(matrix = infile, 
    type = "csv", folder = "output")
}
}
