% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_time_var.R
\name{filter_by_time_var}
\alias{filter_by_time_var}
\title{Filter by Time Variable}
\usage{
filter_by_time_var(df, id, time_var, pre, post, vars)
}
\arguments{
\item{df}{A data frame which must have a column to identify two different groups by ID.}

\item{id}{The column variable that will contain all of the IDs that show up twice in the data set.}

\item{time_var}{The column variable that designates the time of the data, e.g., it may be a 0 if
data was collected on the first day of treatment and a 6 if data is collected six days later.}

\item{pre}{The value in the \code{time_var} column that indicates the 'pre' time point.}

\item{post}{The value in the \code{time_var} column that indicates the 'post' time point.}

\item{vars}{The column variables the researcher is interested in. The researcher can subset the
columns instead of using all potential column variables.}
}
\value{
A list of two data frames that are subsets of the original data frame, separated
by their \code{time_var} status. The data frames will have the same size in rows.
}
\description{
This function creates two groups based on their ID and separates them by a time variable.
Each ID will be present in each subset exactly once. The subsets will contain the same variables specified by the user.
}
\details{
This function checks if the input data frame, ID, time variable, and column
variablesare valid. It ensures that the specified pre and post values exist within the
time variable column. The function then filters the data for each time point, orders the
IDs, and returns a list containing the filtered data frames.
}
\examples{
# Load example data
data("pre_post_data_example")

# Use the function to filter by time variable
result <- filter_by_time_var(pre_post_data_example, id = "ID",
time_var = "time", pre = 0, post = 12, vars = c("v1", "v2"))
print(result$pre)
print(result$post)

}
