% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize_data.R
\name{.create_design_matrix}
\alias{.create_design_matrix}
\title{Create the Design Matrix for a Simulation}
\usage{
.create_design_matrix(design, current_n, n_is_total = TRUE)
}
\arguments{
\item{design}{A \code{PowRPriori_design} object from \code{define_design()}.}

\item{current_n}{The sample size for which the design matrix should be generated.}

\item{n_is_total}{A boolean that controls how \code{current_n} is interpreted. \code{TRUE} assumes that the whole sample used for the simulation should be size
\code{current_n}, \code{FALSE} assumes that \code{current_n} specifies the size of each cell as defined by \code{design}.}
}
\value{
A tibble (data frame) with predictor variables.
}
\description{
An internal helper function that takes the design specification and a sample
size to generate a single data frame representing all observations for one
simulation run. It handles within-, between-, nested, and crossed factors.
}
