% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr.R
\name{hrStat}
\alias{hrStat}
\title{UMP beta p-value pooled statistic}
\usage{
hrStat(p, w = 1)
}
\arguments{
\item{p}{numeric vector of p-values between 0 and 1}

\item{w}{numeric value between 0 and 1}
}
\value{
A numeric value giving the pooled statistic.
}
\description{
Computes the UMP p-value pooling statistic for a
restricted beta family.
}
\details{
To test the null hypotheses that all p-values are uniform
against a restricted beta family 0 < a <= 1 <= b, the most
powerful pooled p-value linearly combines upper and lower tail
probabilities of the chi-squared distribution with two degrees
of freedom with weights w and (1 - w) where w = (1 - a)/(b - a).

This function computes the statistic given by this combination
for a collection of p-values, simulation or approximation is
required to convert this to a p-value.
}
\examples{
p <- c(0.1, 0.5, 0.9)
hrStat(p, 0.2)
hrStat(p, 0.5)
hrStat(p, 0.9)
}
\author{
Chris Salahub
}
