% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentChi.R
\name{convertGeneticSigma}
\alias{convertGeneticSigma}
\title{Convert p-value correlation to chi-squared covariance}
\usage{
convertGeneticSigma(sigma, kappa, models = chiCorMods)
}
\arguments{
\item{sigma}{M by M correlation matrix between markers}

\item{kappa}{numeric degrees of freedom}

\item{models}{model object with a predict method}
}
\value{
M by M matrix of chi-squared covariances
}
\description{
Convert a matrix of correlations between p-values to
a matrix of covariances between their chi-squared transforms.
}
\details{
This function uses models fit to large simulated data
sets to convert a matrix of correlations between genetic markers
the covariance matrix of chi-squared random variables gained from
transforming p-values on these markers. The simulations used to
create data for these models assume the p-values for each marker
arise from tests of association with a common, normally
distributed trait independent of all markers. As a result, this
conversion function should be used only in analogous settings.

Models were fit for degrees of freedom at increments of 0.1
between -8 and 8 on the log scale, and interpolation is applied
if the degrees of freedom given to the function does not fall
exactly on this grid (with a warning provided to the user).

If a user wants to generalize this setting, the option to
provide a custom list of models which predict based on a named
argument `zcor` is supported. Each model must have a name in the
list that can be converted to a numeric, and these are assumed
to be on the natural log scale.
}
\author{
Chirs Salahub
}
