% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{chemospec_to_plotftir}
\alias{chemospec_to_plotftir}
\title{`ChemoSec` to `PlotFTIR` conversions}
\usage{
chemospec_to_plotftir(csdata)
}
\arguments{
\item{csdata}{`ChemoSpec` data to convert to `PlotFTIR.`
Données `ChemoSpec` a convertir à `PlotFTIR`.}
}
\value{
a data.frame compatible with `PlotFTIR` functions

un data.frame compatible avec les fonctions `PlotFTIR`.
}
\description{
Converts `ChemoSpec` data to that ready to use by `PlotFTIR`.

Convertit les données `ChemoSpec` en données prêtes à être utilisées par `PlotFTIR`.
}
\examples{
if (requireNamespace("ChemoSpec", quietly = TRUE)) {
  # convert `chemospec` to PlotFTIR data
  data("SrE.IR", package = "ChemoSpec", envir = environment())
  chemospec_to_plotftir(SrE.IR)
}
}
\seealso{
[ChemoSpec::files2SpectraObject()] for import requirements, and [chemospec_to_plotftir()] for converting to `PlotFTIR` format.

[ChemoSpec::files2SpectraObject()] pour les conditions d'importation, et [chemospec_to_plotftir()] pour la conversion au format `PlotFTIR`.
}
