% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_plate}
\alias{import_plate}
\title{Import and Merge PCR Data}
\usage{
import_plate(raw_file, map_file, skip_rows = 0)
}
\arguments{
\item{raw_file}{Path to the machine excel output (.xls or .xlsx).}

\item{map_file}{Path to the user-defined CSV map (Cols: Well, Sample, Gene, Group).}

\item{skip_rows}{Number of rows of metadata to skip in the raw file (default 0).}
}
\value{
A clean, merged tibble ready for analysis.
}
\description{
Reads the raw machine export and merges it with a user-defined layout map.
}
\examples{
# Locate the sample data bundled with the package
my_raw <- system.file("extdata", "experiment_data.xlsx", package = "PlateVision")
my_map <- system.file("extdata", "plate_map.csv", package = "PlateVision")

# Run import
if(file.exists(my_raw) && file.exists(my_map)) {
  df <- import_plate(raw_file = my_raw, map_file = my_map)
  head(df)
}
}
