% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSI.R
\name{RSI}
\alias{RSI}
\title{Relative Stress Index (RSI)}
\usage{
RSI(Gen, YN, YS, YMN = NULL, YMS = NULL)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMN}{Optional numeric scalar: mean of \code{YN}. If NULL, computed.}

\item{YMS}{Optional numeric scalar: mean of \code{YS}. If NULL, computed.}
}
\value{
A list with \code{YMN}, \code{YMS}, and \code{Result} (data frame with \code{Gen}, \code{RSI}).

\deqn{RSI = \frac{(YN/YS)}{(YMS/YMN)}}
}
\description{
This function computes Relative Stress Index (RSI) using any traits (like yield) under stress and non-stress conditions. The lower values of RSI indicates greater tolerance. For more details see Fischer and Wood (1979) \url{doi:10.1071/AR9791001}.
}
\examples{
out = RSI(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Fischer, R.A. and Wood, J.T. (1979). Drought resistance in spring wheat cultivars. III.* Yield associations with morpho-physiological traits. Australian Journal of Agricultural Research, 30(6), 1001-1020.
}
