% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyclopsSettings.R
\name{setCoxModel}
\alias{setCoxModel}
\title{Create setting for lasso Cox model}
\usage{
setCoxModel(
  variance = 0.01,
  seed = NULL,
  includeCovariateIds = c(),
  noShrinkage = c(),
  threads = -1,
  upperLimit = 20,
  lowerLimit = 0.01,
  tolerance = 2e-07,
  maxIterations = 3000
)
}
\arguments{
\item{variance}{Numeric: prior distribution starting variance}

\item{seed}{An option to add a seed when training the model}

\item{includeCovariateIds}{a set of covariate IDS to limit the analysis to}

\item{noShrinkage}{a set of covariates whcih are to be forced to be included in the final model. default is the intercept}

\item{threads}{An option to set number of threads when training model}

\item{upperLimit}{Numeric: Upper prior variance limit for grid-search}

\item{lowerLimit}{Numeric: Lower prior variance limit for grid-search}

\item{tolerance}{Numeric: maximum relative change in convergence criterion from successive iterations to achieve convergence}

\item{maxIterations}{Integer: maximum iterations of Cyclops to attempt before returning a failed-to-converge error}
}
\value{
\code{modelSettings} object
}
\description{
Create setting for lasso Cox model
}
\examples{
coxL1 <- setCoxModel()
}
