
## `PakPMICS2018`: Multiple Indicator Cluster Survey (MICS) 2017-18 Data for Punjab, Pakistan

###### Version : [1.2.0](https://myaseen208.com/PakPMICS2018/); License: [GPL-3](https://www.r-project.org/Licenses/)

##### *Muhammad Yaseen<sup>1,2</sup>*

1.  School of Mathematical & Statistical Sciences, Clemson University,
    Clemson, South Carolina, USA
2.  Department of Mathematics & Statistics, University of Agriculture
    Faisalabad, Pakistan

------------------------------------------------------------------------

[![minimal R
version](https://img.shields.io/badge/R%3E%3D-3.5.0-6666ff.svg)](https://cran.r-project.org/)
[![License: GPL
v3](https://img.shields.io/badge/License-GPL%20v3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)
[![CRAN_Status_Badge](https://www.r-pkg.org/badges/version-last-release/PakPMICS2018)](https://cran.r-project.org/package=PakPMICS2018)
[![rstudio mirror
downloads](https://cranlogs.r-pkg.org/badges/grand-total/PakPMICS2018?color=green)](https://CRAN.R-project.org/package=PakPMICS2018)
<!-- [![packageversion](https://img.shields.io/badge/Package%20version-0.2.3.3-orange.svg)](https://github.com/myaseen208/PakPMICS2018) -->

[![develVersion](https://img.shields.io/badge/devel%20version-1.1.0-orange.svg)](https://github.com/myaseen208/PakPMICS2018)

<!-- [![GitHub Download Count](https://github-basic-badges.herokuapp.com/downloads/myaseen208/PakPMICS2018/total.svg)] -->

[![Project Status:
WIP](http://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![lifecycle](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
[![Last-changedate](https://img.shields.io/badge/last%20change-2024--11--10-yellowgreen.svg)](https://github.com/myaseen208/PakPMICS2018)

------------------------------------------------------------------------

## Description

Provides data set and function for exploration of Multiple Indicator
Cluster Survey (MICS) 2017-18 data for Punjab, Pakistan. The results of
the present survey are critically important for the purposes of SDG
monitoring, as the survey produces information on 32 global SDG
indicators. The data was collected from 53,840 households selected at
the second stage with systematic random sampling out of a sample of
2,692 clusters selected using Probability Proportional to size sampling.
Six questionnaires were used in the survey: (1) a household
questionnaire to collect basic demographic information on all de jure
household members (usual residents), the household, and the dwelling;
(2) a water quality testing questionnaire administered in three
households in each cluster of the sample; (3) a questionnaire for
individual women administered in each household to all women age 15-49
years; (4) a questionnaire for individual men administered in every
second household to all men age 15-49 years; (5) an under-5
questionnaire, administered to mothers (or caretakers) of all children
under 5 living in the household; and (6) a questionnaire for children
age 5-17 years, administered to the mother (or caretaker) of one
randomly selected child age 5-17 years living in the household.

## Installation

The package can be installed from CRAN as follows:

``` r
install.packages("PakPMICS2018", dependencies = TRUE)
```

The development version can be installed from github as follows:

``` r
if (!require("remotes")) install.packages("remotes")
remotes::install_github("myaseen208/PakPMICS2018")
```

## What’s new

To know whats new in this version type:

``` r
news(package = "PakPMICS2018")
```

## Links

[CRAN page](https://cran.r-project.org/package=PakPMICS2018)

[Github page](https://github.com/myaseen208/PakPMICS2018)

[Documentation website](https://myaseen208.com/PakPMICS2018/)

## Citing `PakPMICS2018`

To cite the methods in the package use:

``` r
citation("PakPMICS2018")
```

    Please, support this project by citing it in your publications!

      Yaseen M (2019). _PakPMICS2018: Multiple Indicator Cluster Survey
      (MICS) 2017-18 Data for Punjab, Pakistan_.

    A BibTeX entry for LaTeX users is

      @Manual{,
        title = {PakPMICS2018: Multiple Indicator Cluster Survey (MICS) 2017-18 Data for Punjab, Pakistan},
        author = {Muhammad Yaseen},
        year = {2019},
        journal = {The Comprehensive R Archive Network (CRAN)},
      }
