% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPareArticle.R
\name{addPareArticle}
\alias{addPareArticle}
\title{addPareArticle}
\usage{
addPareArticle(repo)
}
\arguments{
\item{repo}{(\link[PaRe]{Repository})
Repository object.}
}
\value{
\code{NULL}
Writes Rmd-file to ./vignettes/articles/PaReReport.Rmd
}
\description{
Writes an Rmd-file to \code{./vignettes/articles/PaReReport.Rmd}. The relative
path is dictated by the specified path in the \link[PaRe]{Repository} object.
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/darwin-eu/IncidencePrevalence.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  # Run makeReport on the Repository object.
  addPaReArticle(repo)
}
}
