% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWEV.R
\name{PWEV}
\alias{PWEV}
\title{PSO Based Weighted Ensemble Algorithm for Volatility Modelling}
\usage{
PWEV(Data, SplitR)
}
\arguments{
\item{Data}{Univariate Time Series Data}

\item{SplitR}{Split Ratio}
}
\value{
\itemize{
  \item TrainFitted: Fitted values for the train series
  \item TestPred: Prediction for the test series
  \item Accuracy: Accuracy metric of the proposed model
  \item Weights: Weights of the ensemble
}
}
\description{
PSO Based Weighted Ensemble Algorithm for Volatility Modelling
}
\examples{
\donttest{
library("PWEV")
data<- as.ts(rnorm(200,100,50))
Result <- PWEV(data, 0.9)
}
}
\references{
\itemize{
\item Paul, R.K., Das, T. and Yeasin, M., 2023. Ensemble of time series and machine learning model for forecasting volatility in agricultural prices. National Academy Science Letters, 46(3), pp.185-188.
\item Yeasin, M. and Paul, R.K., 2024. OptiSembleForecasting: optimization-based ensemble forecasting using MCS algorithm and PCA-based error index. The Journal of Supercomputing, 80(2), pp.1568-1597.
}
}
