% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raynercolor.LAB.R
\name{raynercolor.LAB}
\alias{raynercolor.LAB}
\title{raynercolor.LAB}
\usage{
raynercolor.LAB(fungi, distance.method = "euclidean")
}
\arguments{
\item{fungi}{Image of fungi in transparent background}

\item{distance.method}{Metrics for color-matching ("euclidean", or "chisq")}
}
\value{
Color names, 3D LAB plot, color histogram
}
\description{
Generates results for color names from the CIELAB color space
}
\examples{
raynercolor.LAB(system.file("fungi.png", package = "PUPMCR"))
\dontrun{raynercolor.LAB("fungi_image_format")}
}
\references{
Rayner, R. (1970, ISBN:9780851980263). Mycological Colour Chart. UK: Commonwealth Mycological Insitute and British Mycological Society.

Conlan, X. A., Kalra. R., and Goel M. (2020) <doi:10.3389/fchem.2020.00369> Fungi as a Potential Source of Pigments: Harnessing Filamentous Fungi. Front. Chem, 8:369.

Cejpek, K. and Valisek, J. (2011) <doi:10.17221/524/2010-cjfs> Pigments of Higher Fungi: A review. Czech J. Food Sci., 29:87-102.
}
\author{
Niña Rose E. Zapanta

Jericho Ivan Pineda

Rhenz Hannah R. Santos

Lourdes V. Alvarez

Chester C. Deocaris
}
