% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MBMGAC_PSSM.R
\name{MBMGACPSSM}
\alias{MBMGACPSSM}
\title{MBMGACPSSM feature}
\usage{
MBMGACPSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 560
}
\description{
In this function three different autocorrelation descriptors based on PSSM are adopted,
which include: normalized Moreau-Broto autocorrelation, Moran autocorrelation and Geary autocorrelation
descriptors.Autocorrelation descriptor is a powerful statistical tool and defined based on the distribution
of amino acid properties along the sequence, which measures the correlation between two residues separated
by a distance of d in terms of their evolution scores.
}
\examples{
X<-MBMGACPSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Y. Liang, S. Liu, S. J. M. C. i. M. Zhang, and i. C. Chemistry, "Prediction of protein structural class
based on different autocorrelation descriptors of position-specific scoring matrix,"
vol. 73, no. 3, pp. 765-784, 2015.
}
