% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_cosin.R
\name{Discrete_Cosine_Transform}
\alias{Discrete_Cosine_Transform}
\title{Discrete Cosin Transform Feature}
\usage{
Discrete_Cosine_Transform(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 400
}
\description{
To construct this feature vector, Two-Dimensional DCT algorithm has been used by applying
\code{\link[dtt]{dct}} function from dtt package which DCT stands for Discrete Cosin Transform.
}
\examples{
X<-Discrete_Cosine_Transform(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Wang, L., et al., Advancing the prediction accuracy of protein-protein interactions by utilizing
evolutionary information from position-specific scoring matrix and ensemble classifier. 2017. 418: p. 105-110.

Y. Wang, Y. Ding, F. Guo, L. Wei, and J. J. P. o. Tang, "Improved detection of DNA-binding proteins
via compression technology on PSSM information," vol. 12, no. 9, 2017.
}
