% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod3.test.R
\name{Mod3.test}
\alias{Mod3.test}
\title{Modular test for independence in three-way contingency table}
\usage{
Mod3.test(nijt, B = 10000)
}
\arguments{
\item{nijt}{a numeric matrix with non-negative values of the three-way contingency table cells}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns values of the test statistic and p-value of the modular test.
}
\description{
Calculates the test statistic and p-value of the modular test for independence in three-way contingency table
}
\details{
The test statistic and p-value of the modular test for independence in r x c x t contingency table,
}
\examples{
\donttest{Mod3.test(GenTab3(array(0.125, dim = c(2, 2, 2)), 80), B = 1e3)}
\donttest{Mod3.test(table4, B = 1e3)}

}
\references{
{Sulewski, P. (2018). \emph{Power Analysis Of Independence Testing for the Three-Way Con-tingency Tables of Small Sizes.} Journal of Applied Statistics 45(13), 2481-2498}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
