% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mod2.pvalue.R
\name{Mod2.pvalue}
\alias{Mod2.pvalue}
\title{Modular test for independence in two-way contingency table}
\usage{
Mod2.pvalue(stat, nr, nc, n, B = 10000)
}
\arguments{
\item{stat}{a modular statistic value}

\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{n}{a sample size}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the p-value of the modular test.
}
\description{
Calculates the p-value of the modular test for independence in two-way contingency table
}
\details{
The p-value of the modular test for independence in r x c contingency table,
}
\examples{
pij=matrix(1/4, nrow = 2, ncol = 2)
tab4=GenTab2(pij, 30)
Mod2.pvalue(Mod2.stat(tab4), 2, 2, 30, B=1e3)
\donttest{Mod2.pvalue(2.5, 3, 2, 60)}

}
\references{
{Sulewski, P. (2016). \emph{Moc testów niezależności w tablicy dwudzielczej większej niż 2×2,} Przegląd statystyczny 63(2), 190-210}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
