% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ti_pp.R
\name{ti_pp}
\alias{ti_pp}
\title{Probability of Passing PPQ Test using Tolerance Interval}
\usage{
ti_pp(Llim, Ulim, mu, sigma, n, n.batch, alpha, coverprob, side)
}
\arguments{
\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{alpha}{significant level for constructing the tolerance interval}

\item{coverprob}{coverage probability for constructing the tolerance interval}

\item{side}{whether a 1-sided or 2-sided tolerance interval is required (determined by side = 1 or side = 2, respectively).}
}
\value{
A numeric value of the passing/acceptance probability
}
\description{
The function for calculating the probability of passing critical quality attributes (CQA) PPQ test .
}
\examples{
ti_pp(sigma=0.5, mu=2.5, n=10, n.batch=1, Llim=1.5, Ulim=3.5, alpha=0.05)

sapply(X=c(0.1,0.5, 1,2,3,4,5,10), FUN = ti_pp, mu=97, n=10, Llim=95, Ulim=105,
n.batch=1, alpha=0.05)
sapply(X=c(0.1,0.5, 1,2,3,4,5,10), FUN = ti_pp, mu=100, n=10, Llim=95, Ulim=105,
n.batch=1, alpha=0.05)
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{rl_pp}.
}
\author{
Yalin Zhu
}
