% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPQ_ggplot.R
\name{PPQ_ggplot}
\alias{PPQ_ggplot}
\title{Heatmap/Contour Plot for Dynamically Assessing Power of the CQA PPQ Plan Using General Multiplier.}
\usage{
PPQ_ggplot(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, k,
test.point, dynamic)
}
\arguments{
\item{attr.name}{(optional) user-defined attribute name for PPQ assessment}

\item{attr.unit}{(optional) user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{k}{general multiplier for constructing the specific interval}

\item{test.point}{(optional) actual process data points for testing whether the processes pass PPQ}

\item{dynamic}{logical; if \code{TRUE}, then convert the heatmap ggplot to dynamic graph using plotly.}
}
\value{
Dynamic Heatmap (or Contour Plot) for PPQ Assessment.
}
\description{
The function for dynamically plotting (ggplot) the heatmap to evaluate the PPQ plan based on the specification test, given lower and upper specification limits.
}
\examples{
\dontrun{
mu <- seq(95, 105, 0.1)
sigma <- seq(0.1,1.7,0.1)
PPQ_ggplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%", Llim=95, Ulim=105,
mu = mu, sigma = sigma, k=2.373, dynamic = FALSE)
test <- data.frame(mu=c(97,98.3,102.5), sd=c(0.55, 1.5, 0.2))
PPQ_ggplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%", Llim=95, Ulim=105,
mu = mu, sigma = sigma, k=2.373, test.point = test)
}
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{PPQ_pp} and \code{PPQ_occurve}.
}
\author{
Yalin Zhu
}
