#' @title Identify the candidate prognosis-related pathways
#' @description The function `get_final_signature` uses to identify the candidate prognosis-related pathways based on the PMAPscore.
#' @param pfs_score A 2 X n matrix that contains the pfs_score in each sample of the signal pathways. Noted the matrix can be generated by the function `get_pfs_score`.
#' @param sur This data contains survival status and survival time of each sample.
#' @param wilcox_p The threshold of p value for Wilcoxon rank-sum test.
#' @param uni_cox_p The threshold of p value for univariate Cox regression analysis.
#' @return Return the candidate prognosis-related pathways
#' @importFrom survival coxph
#' @importFrom glmnet cv.glmnet
#' @importFrom stats wilcox.test
#' @importFrom survival Surv
#' @importFrom stats na.omit
#' @importFrom stats coef
#' @export
#' @examples
#' #load the data.
#' data(pfs_score,sur)
#' #perform function `get_final_signature`.
#' final_signature<-get_final_signature(pfs_score,sur)



get_final_signature<-function(pfs_score,sur,wilcox_p=0.05,uni_cox_p=0.01){
  inter<-intersect(rownames(sur),colnames(pfs_score))
  pfs_score<-pfs_score[,inter]
  sur<-sur[inter,]
  pfs_score<-as.matrix(pfs_score)
  wilcox<-apply(pfs_score,1,function(x){wilcox.test(x[which(sur$STATUS==0)],x[-which(sur$STATUS==0)])$p.value})
  wilcox<-as.matrix(wilcox)
  wilcox_path<-rownames(wilcox)[which(wilcox[,1]<wilcox_p)]
  pfs_score<-pfs_score[match(wilcox_path,rownames(pfs_score)),]
  mutantdata1<-t(pfs_score)
  path_name<-cbind(colnames(mutantdata1),paste0("a",1:length(colnames(mutantdata1))))
  colnames(mutantdata1)<-path_name[,2]
  lo<-match(rownames(mutantdata1),rownames(sur))
  mutantdata1<-cbind(mutantdata1,sur[lo,2])
  mutantdata1<-cbind(mutantdata1,sur[lo,1])
  colnames(mutantdata1)[dim(mutantdata1)[2]-1]<-"survival"
  colnames(mutantdata1)[dim(mutantdata1)[2]]<-"event"
  DE_path_sur<-mutantdata1
  DE_path_sur<-as.data.frame(DE_path_sur)
  path_Ucox_res<-get_univarCox_result(DE_path_sur)
  pfs_score<-t(pfs_score)
  colnames(pfs_score)<-path_name[,2]
  pfs_score<-pfs_score[,match(rownames(path_Ucox_res)[which(path_Ucox_res$p.value<uni_cox_p)],colnames(pfs_score))]
  data1<-sur[,c(1,2)]
  data1[] <- lapply(data1, as.numeric)
  colnames(data1)<-c("status","time")
  data1<-as.matrix(data1)
  lo<-match(rownames(data1),rownames(pfs_score))
  path_mut1<-pfs_score[na.omit(lo),]
  data2<-data1[match(rownames(path_mut1),rownames(data1)) ,]
  lasso.cv <- cv.glmnet(path_mut1,data2,family="cox",alpha=1)
  coef_lasso <- as.data.frame(as.matrix(coef(lasso.cv,s=lasso.cv$lambda.min)))
  pathway_result <- rownames(coef_lasso)[which(coef_lasso$`1`!=0)]
  pathway_result<-path_name[match(pathway_result,path_name[,2]),1]
  return(pathway_result)
}
