% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.rank.R
\name{p.rank}
\alias{p.rank}
\title{Visualize R-squared value distribution in predictor-environment interaction}
\usage{
p.rank(
  x,
  y,
  method = "linear",
  lower.thr = 0,
  n.pred = ncol(x),
  upper.xlim = ncol(x)
)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of an environment in which the samples were collected.}

\item{method}{A string to specify the method of regression for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" regression model can be specified.}

\item{lower.thr}{The lower threshold of R-squared value to be included in PLORN model (default: 0).}

\item{n.pred}{The number of predictors to be included in PLORN model (default: ncol(x)).}

\item{upper.xlim}{The upper limitation of x axis (i.e., the number of predictors) in the resulted figure (default: ncol(x)).}
}
\value{
A rank order plot
}
\description{
Visualize R-squared value distribution in predictor-environment interaction
}
\examples{
data(Pinus)
train <- p.clean(Pinus$train)
target <- Pinus$target
train <- p.sort(train, target)
p.rank(train, target)
}
\author{
Takahiko Koizumi
}
