% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_regimen.R
\name{new_regimen}
\alias{new_regimen}
\title{Dose regimen for sim_ode}
\usage{
new_regimen(
  amt = 100,
  interval = NULL,
  n = 3,
  times = NULL,
  type = NULL,
  t_inf = NULL,
  rate = NULL,
  t_lag = NULL,
  cmt = NULL,
  checks = TRUE,
  ss = FALSE,
  n_ss = NULL,
  first_dose_time = now_utc()
)
}
\arguments{
\item{amt}{dosing amount, either a single value (which will repeated for multiple doses), or a vector with doses for each administration}

\item{interval}{dosing interval (requires n as argument)}

\item{n}{number of doses (requires interval as argument)}

\item{times}{vector describing dosing times. Overrides specified times using interval and n arguments}

\item{type}{either "infusion", "bolus", "oral", "sc" (subcutaneous), or "im" (intramuscular).}

\item{t_inf}{infusion time (if \code{type}==\code{infusion})}

\item{rate}{infusion rate (if \code{type}==\code{infusion}). \code{NULL} by default. If specified, overrides \code{t_inf}}

\item{t_lag}{lag time (can be applied to any dose type, not only oral). Will just be added to \code{times}}

\item{cmt}{vector of dosing compartments (optional, if NULL will dosing compartment defined in model will be used)}

\item{checks}{input checks. Remove to increase speed (e.g. for population-level estimation or optimal design)}

\item{ss}{steady state? boolean value whether to simulate out to steady state first (steady state will be based on specified \code{amt} and \code{interval}, \code{times} will be ignored).}

\item{n_ss}{how many doses to simulate before assumed steady state. Default is 4 * 24 / \code{interval}.}

\item{first_dose_time}{datetime stamp of first dose (of class \code{POSIXct}). Default is current date time.}
}
\value{
a list containing calculated VPC information, and a ggplot2 object
}
\description{
Create a dosing regimen for use with sim_ode
}
\examples{

r1 <- new_regimen(amt=50, interval=12, n=20) # dose 50mg, q12hrs for 10 days
r2 <- new_regimen(amt=50, times=c(0:19)*12)  # same, but using explicit times
r3 <- new_regimen(amt=c(rep(100,4), rep(50,16)), times=c(0:19)*12)  # first 4 doses higher dose
}
\seealso{
\link{sim_ode}
}
