% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCC.XBAR.R
\name{getCC.XBAR}
\alias{getCC.XBAR}
\alias{getCC}
\title{Random Flexible Level Shift Model}
\usage{
getCC.XBAR(
  m,
  fap0 = 0.05,
  var.est = c("S", "MR"),
  ub.cons = 1,
  method = c("exact", "BA"),
  interval = c(1, 4),
  nsim = 10000,
  nu = m - 1,
  lambda = 1,
  verbose = FALSE
)
}
\arguments{
\item{m}{number of subgroups when the data are subgrouped or number of observations when the data are individual.}

\item{fap0}{nominal False Alarm Probabilty in Phase 1}

\item{var.est}{'S' - use mean-square-based estimator, 'MR' - use moving-range-based estimator}

\item{ub.cons}{unbiasing constant}

\item{method}{'exact' - calculate results using the exact method, 'BA' - calculate results using the Bonfferoni approximation}

\item{interval}{searching range of charting constants for the exact method}

\item{nsim}{number of simulation for the exact method}

\item{nu}{degrees of freedom; When var.est = 'S', the degrees of freedom is that of the chi-squared distribution itself for the variance estimator.  When var.est = 'MR', the degrees of freedom is that of the chi-squared distribution approximating to the actual distribution.}

\item{lambda}{unbiasing constant for the chi-squared distribution approximation. When var.est = 'S', there is no need to do the unbiasing.  When var.est = 'MR', the unbiasing constant needs to be used.}

\item{verbose}{print diagnostic information about fap0 and the charting constant during the simulations for the exact method}
}
\value{
Object type double. The corrected charting constant.
}
\description{
get Phase I corrected charting constant
}
\examples{
set.seed(12345)

# Calculate the charting constant using 10 simulations and mean-square-based estimator
getCC.XBAR(fap0=0.05, m=20, nsim=10, var.est='S', verbose = TRUE)

# Calculate the charting constant using 10 simulations and moving-range-based estimator
getCC.XBAR(fap0=0.05, m=20, nsim=10, var.est='MR', verbose = TRUE)


}
