% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_sitedata.R
\name{pfw_sitedata}
\alias{pfw_sitedata}
\title{Merge Site Metadata into Project FeederWatch Data}
\usage{
pfw_sitedata(data, path)
}
\arguments{
\item{data}{A Project FeederWatch dataset.}

\item{path}{File path to the site description .csv from https://feederwatch.org/explore/raw-dataset-requests/. If not specified, defaults to "data-raw/sitedata.csv".}
}
\value{
The original dataset with site metadata merged in.
}
\description{
This function joins habitat and site metadata into Project FeederWatch
observation data using the site description file.If the site metadata
file is not found, it will be downloaded automatically to
the designated path or "data-raw" if no path is selected.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download/loads the example dataset
data <- pfw_example

# Merge site metadata into example observation data
data_sites <- pfw_sitedata(data, "data-raw/site_data.csv")
\dontshow{\}) # examplesIf}
}
