% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Parameter_estimation_and_hypothesis_testing.R
\name{sample.test}
\alias{sample.test}
\title{Lagrange Multiplier Test for \eqn{\psi}}
\usage{
sample.test(abund, psi = "a")
}
\arguments{
\item{abund}{An abundance vector of a sample.}

\item{psi}{Target positive number \eqn{\psi_0} to be tested. Accepted values are "a" for absolute value 1,
"r" for relative value \eqn{n} (sample size), or any positive number.}
}
\value{
The statistic \eqn{S} and a p-value of the two-sided test of the hypothesis.
}
\description{
Performs the Lagrange Multiplier test for the equality of the dispersion parameter \eqn{\psi} of a sample.
The null hypothesis of the test is \eqn{H_0: \psi = \psi_0}, where \eqn{\psi_0} is given as input here.
}
\details{
Calculates the Lagrange Multiplier test statistic \deqn{S\, = \,U(\psi_0)^2 / I(\psi_0),}
where \eqn{U} is the log-likelihood function of \eqn{\psi} and \eqn{I} is its Fisher information.
The statistic \eqn{S} follows \eqn{\chi^2}-distribution with 1 degree of freedom
when the null hypothesis \eqn{H_0:\psi=\psi_0} is true.
}
\examples{
## Test the psi of a sample from the Poisson-Dirichlet distribution:
set.seed(10000)
x<-rPD(1000, 10)
## Find the abundance of the data vector:
abund=abundance(x)
## Test for the psi that was used, as well as a higher and a lower one:
sample.test(abund, 10)
sample.test(abund, 15)
sample.test(abund, 5)
sample.test(abund)       #test for psi=1
sample.test(abund, "r")  #test for psi=n
}
\references{
Radhakrishna Rao, C, (1948), Large sample tests of statistical
hypotheses concerning several parameters with applications to problems of
estimation. Mathematical Proceedings of the Cambridge Philosophical Society,
44(1), 50-57. <\doi{10.1017/S0305004100023987}>
}
\keyword{score}
\keyword{test}
