% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PD_distribution.R
\name{rPD}
\alias{rPD}
\title{Random sampling from the Poisson-Dirichlet Distribution}
\usage{
rPD(n, psi)
}
\arguments{
\item{n}{number of observations.}

\item{psi}{dispersal parameter.}
}
\value{
Returns a vector with a sample of size \eqn{n} from the Hoppe urn model with parameter \eqn{\psi}.
}
\description{
rPD samples randomly from the PD distribution with a given \eqn{\psi} by simulating the Hoppe urn model.
}
\details{
Samples random values with a given \eqn{\psi} from the Poisson-Dirichlet distribution by simulating the Hoppe urn model.
}
\examples{
## Get random sample from the PD distribution with different psi,
## and estimate the psi of the samples:
s1<-rPD(1000, 10)
s2<- rPD(1000, 50)
print(c(MLEp(abundance(s1)), MLEp(abundance(s2))))

}
\references{
Hoppe, F.M. The sampling theory of neutral alleles and an urn model in population genetics.
J. Math. Biology 25, 123–159 (1987). <\doi{10.1007/BF00276386}>.

W.J. Ewens, The sampling theory of selectively neutral alleles, Theoretical Population Biology, Volume 3, Issue 1,
1972, Pages 87-112, ISSN 0040-5809, <\doi{10.1016/0040-5809(72)90035-4}>.
}
\keyword{Poisson-Dirichlet}
\keyword{distribution}
