% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_output_functions.R
\name{f_plot_tp_cure_surv_model}
\alias{f_plot_tp_cure_surv_model}
\title{Plot Annual Transition Probabilities for Cure Survival Models}
\usage{
f_plot_tp_cure_surv_model(PERSUADE, model_index = 1)
}
\arguments{
\item{PERSUADE}{A PERSUADE object returned by \code{\link[=f_PERSUADE]{f_PERSUADE()}}.}

\item{model_index}{Integer index selecting the cure model within
\code{PERSUADE$surv_model$cure_models} (1-based). Defaults to \code{1}.}
}
\value{
Invisibly returns \code{NULL}. The function draws a base R plot as a side effect.
}
\description{
Plot smoothed observed annual transition probabilities with shaded confidence
intervals, overlaid with predictions from a selected cure survival model
(mixture or non-mixture; Weibull, log-normal, or log-logistic).
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = TRUE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
f_plot_tp_cure_surv_model(PERSUADE, model_index = 1)
}

}
\seealso{
\code{\link[=f_PERSUADE]{f_PERSUADE()}}
}
